/**
* \file: WaylandInputSource.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: M. Adachi / ADITJ/SW1 / madachi@jp.adit-jv.com
*
* \copyright (c) 2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/
#include <adit_logging.h>
#include "WaylandInputSource.h"
#include "WaylandInputSourceImpl.h"

LOG_IMPORT_CONTEXT(aauto_input)

namespace adit { namespace aauto {

WaylandInputSource::WaylandInputSource(uint8_t inSessionId, MessageRouter* inMessageRouter)
 : AditInputSource(inSessionId, inMessageRouter)
{
    impl = new WaylandInputSourceImpl(this, (void*)inMessageRouter);
}

WaylandInputSource::~WaylandInputSource()
{
    /* Deleted at GalReceiver destruction, impl is registered as a callback and hold in a shared pointer */
//    delete impl;
}

bool WaylandInputSource::init()
{
    return impl->init();
}

bool WaylandInputSource::shutdown()
{
    return impl->shutdown();
}

void WaylandInputSource::setConfigItem(string inKey, string inValue)
{
    return impl->setConfigItem(inKey, inValue);
}

void WaylandInputSource::registerCallbacks(IAditInputSourceCallbacks* inCallbacks)
{
    return impl->registerCallbacks(inCallbacks);
}

} } // namespace adit { namespace aauto {
